<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RegularCard extends Model 
{

    protected $table = 'regular_cards';
    public $timestamps = true;
    protected $fillable = array('number', 'expiry_date', 'photo', 'balance', 'home_run', 'home_run_price', 'currency_id', 'status', 'grace_period', 'first_amount_currency', 'last_amount_currency', 'first_pay', 'last_pay', 'period', 'content', 'qr');

    public function users()
    {
        return $this->belongsToMany('App\Models\User');
    }

    public function admin()
    {
        return $this->belongsTo('App\Models\Admin');
    }

    public function curreny()
    {
        return $this->belongsTo('App\Models\Currency');
    }

    public function merchants()
    {
        return $this->belongsToMany('App\Models\Merchant');
    }

    public function home_run()
    {
        return $this->hasOne('App\Models\HomeRun');
    }

    public function transactions()
    {
        return $this->belongsToMany('App\Models\Transaction');
    }

}